backupApp.controller('ImportFromServerController', function($scope, $location, AppService, AppUtils, ServerStatus)
{
    $scope.importedBackup = [];
    $scope.callingServer = true;
    $scope.daysOfWeek = AppUtils.daysOfWeek;
    $scope.step = 1;

    AppService.get('/backups/import-from-server').then(function(response) {
        $scope.importedBackups = response.data ?? []
        $scope.step = 2;
        $scope.configurationSelected = false;
    })
    .catch(function() {        
        $scope.importedBackups = []
        $scope.step = 2;
    });


    $scope.RelativeDate = function(date) {
        return AppUtils.RelativeDate(date);
    }

    $scope.importedTaskCompleted = 0;
    $scope.onCompleteTask = function() {
        $scope.importedTaskCompleted++;
        $scope.importComplete = $scope.importedBackups.length <= $scope.importedTaskCompleted;
    }

    $scope.Import = function() {
        $scope.importing = true
        $scope.importedBackups = $scope.importedBackups.filter(b => b.selected);
        $scope.step = 3;
    }

    $scope.CheckSelected = function() {
        $scope.configurationSelected = 0 < $scope.importedBackups.filter(b => b.selected).length;
    }

    $scope.goToMyBackups = function() {
        $location.path('/')
    }
});
