backupApp.controller('RestoreWizardController', function($scope, $location, BackupList, AppUtils, gettextCatalog) {
    let hasBeenchange = false;
    $scope.RestorableBackup = [];
    $scope.backups = BackupList.watch($scope, () => {
        if (hasBeenchange || $scope.backups.length == 0 ) return;

        hasBeenchange = true;
        $scope.selection.backupid = $scope.backups[0].Backup.ID
        $scope.RestorableBackup = $scope.backups.filter(b => {
            return b.Backup.Metadata != null
                && b.Backup.Metadata.LastBackupFinished != null
        })
    });

    $scope.selection = {
        backupid: 'direct'
    };

    $scope.nextPage = function() {
        if ($scope.selection.backupid == 'direct')
            $location.path('/restoredirect');
        else if ($scope.selection.backupid == 'import')
            $location.path('/restore-import');
        else
            $location.path('/restore/' + $scope.selection.backupid);
    };

    $scope.formatDuration = AppUtils.formatDuration;

});
