backupApp.directive('restoreDirectStepOne', function (gettextCatalog) {
    return {
        restrict: 'E',
        scope: {
            uri: '=uri',
            folderPathPrefix: '=',
            isValid: '=',
            encryptionPassphrase: '='
        },
        templateUrl: 'templates/restores/direct/step1.html?v=1.1.2.1',
        controller: function ($scope, $routeParams, AppService, AppUtils, BackupConnectionService, BackupService, SystemInfo, EditUriBackendConfig, DialogService) {
        
            const scope = $scope;
            scope.UseDefaultEncryptionKey = true;
            // $scope.EncryptionPassphrase = null
            scope.serverConfigIsValidated = scope.isValid;

            const reparseuri = function () {

                if (!scope.uri)
                {
                    return;
                }

                scope.ServerConfig = BackupService.reparseuri(scope.uri, scope.folderPathPrefix, scope.DefaultBackend, scope.SystemInfo.GroupedBackendModules);
            };
            
            scope.SystemInfo = SystemInfo.watch($scope, function () {
                for (var n in scope.SystemInfo.GroupedBackendModules)
                    if (scope.SystemInfo.GroupedBackendModules[n].Key == EditUriBackendConfig.defaultbackend)
                        scope.DefaultBackend = scope.SystemInfo.GroupedBackendModules[n];

                reparseuri();
            });

            scope.changeConfiguration = () => scope.serverConfigIsValidated = false;

            scope.testConnection = async function () {
                scope.Testing = true;

                const opts = {};
                EditUriBackendConfig.merge_in_advanced_options(scope.ServerConfig, opts);

                const serverConfig = new ServerConfig(
                    'ssh',
                    scope.ServerConfig.Server,
                    scope.ServerConfig.Port,
                    (scope.ServerConfig.folderPathPrefix || '') + (scope.ServerConfig.Path || ''),
                    AppUtils.encodeDictAsUrl(opts),
                    false,
                )
                try {
                    const res = await BackupConnectionService.checkFolderExist(serverConfig);
                    scope.uri = res;
                    reparseuri();
                    scope.serverConfigIsValidated = true;
                }finally {
                    scope.Testing = false;

                }
            };;

            const checkStepIsValid = function () {
                scope.isValid = scope.serverConfigIsValidated
                    && (
                        scope.UseDefaultEncryptionKey
                        ||
                        (
                            scope.encryptionPassphrase != null
                            &&
                            scope.encryptionPassphrase != ''
                        )
                    );
            }
            

            scope.$watch('uri', reparseuri);
            scope.$watch('serverConfigIsValidated', checkStepIsValid);
            scope.$watch('encryptionPassphrase', checkStepIsValid);
            scope.$watch('UseDefaultEncryptionKey', () => {
                if(scope.UseDefaultEncryptionKey) {
                    scope.encryptionPassphrase = null;
                }
                checkStepIsValid();
            })
        }

    }
});