backupApp.service('BackupService', function($location, $rootScope, $timeout, $cookies, AppService, AppUtils, BackupList, CaptchaService, DialogService, EditUriBackendConfig, gettextCatalog) {
    let backupService = this;
    
    this.DeleteBackup = function(id) {
        let backup = BackupList.lookup[id];

        DialogService.dialog(gettextCatalog.getString('Export configuration'), gettextCatalog.getString('If you want to use the backup later, you can export the configuration before deleting it'), [gettextCatalog.getString('Cancel'), gettextCatalog.getString('Export'), gettextCatalog.getString('Delete')], function(ix) {
            if (ix == 1) {
                backupService.ExportBackup(id);
            }
            else if (ix == 2) {
                deleteBackup(backup.Backup);
            }
        });
    }

    this.ExportBackup = function (BackupID) {        
        let dlIframe = document.createElement('iframe');
        dlIframe.style.display = 'none';
        dlIframe.src = AppService.get_export_url(BackupID, null, true);
        // const fragment = new DocumentFragment();
        // fragment.innerHTML = `<iframe style="display:none" ng-src="=${{DownloadURL}}"></iframe>`;
        document.body.appendChild(dlIframe);
    }

    let deleteBackup = function(backup) {
        DialogService.dialog(gettextCatalog.getString('Confirm delete'), gettextCatalog.getString('Do you really want to delete the backup: "{{name}}" ? (no rollback possible)', {name: backup.Name}), [gettextCatalog.getString('No'), gettextCatalog.getString('Yes')], function(ix) {
            if (ix == 1) {
                catcha(backup);
            }
        });
    }

    let catcha = function(backup) {
        CaptchaService.Authorize(
            gettextCatalog.getString('Confirm delete'), 
            gettextCatalog.getString('To confirm you want to delete all remote files for "{{name}}", please enter the word you see below', {name: backup.Name}),
            'DELETE /backup/' + backup.ID,
            function(token, answer) {
                AppService.delete('/backup/' + backup.ID + '?delete-local-db=true&delete-remote-files=true&captcha-token=' + token + '&captcha-answer=' + answer).then(function() {
                    $location.path('/');
                }, AppUtils.connectionError);
            }
        );
    }

    this.reparseuri = function (uri, folderPathPrefix, defaultBackend, backendModules) {
        const parsedServerConfig = {
            Backend: defaultBackend
        }

        const parts = AppUtils.decode_uri(uri);

        for (var n in backendModules) {
            if (backendModules[n].Key == parts['backend-type']) {
                parsedServerConfig.Backend = backendModules[n];
                break;
            }

            if ((backendModules[n].Key + 's') == parts['backend-type']) {
                var hasssl = false;
                var bk = backendModules[n];

                for (var o in bk.Options) {
                    if (bk.Options[o].Name == 'use-ssl') {
                        hasssl = true;
                        break;
                    }
                }

                if (hasssl) {
                    parsedServerConfig.Backend = bk;
                    parts['--use-ssl'] = true;
                    break;
                }
            }
        }


        parsedServerConfig.Username = parts['--auth-username'];
        parsedServerConfig.Password = parts['--auth-password'];
        parsedServerConfig.UseSSL = parts['--use-ssl'];
        parsedServerConfig.Port = parts['server-port'];
        parsedServerConfig.Server = parts['server-name'];
        parsedServerConfig.Path = parts['server-path'];
        
        if (folderPathPrefix !== undefined) {
            parsedServerConfig.folderPathPrefix = folderPathPrefix;
            if (parsedServerConfig.Path !== undefined) {
                parsedServerConfig.Path = parsedServerConfig.Path.replace(folderPathPrefix, '');
            }
        }

        delete parts['--auth-username'];
        delete parts['--auth-password'];
        delete parts['--use-ssl'];
        delete parts['--ssh-key'];
        parsedServerConfig.AdvancedOptions = AppUtils.serializeAdvancedOptionsToArray(parts);

        return parsedServerConfig;
    };
});