backupApp.directive('backupEditUri', function(gettextCatalog) {
  return {
    restrict: 'E',
    scope: {
        uri: '=uri',
        folderPathPrefix: '=',
        setBuilduriFn: '&',
        isValid: '=',
        remotePathMustExist: '=',
        editable: '=',
    },
    templateUrl: 'templates/edituri.html?v=1.1.2.0',
    controller: function($scope, $routeParams, AppService, AppUtils, BackupService, BackupConnectionService, SystemInfo, EditUriBackendConfig, DialogService, EditUriBuiltins) {

        var scope = $scope;
        scope.AppUtils = AppUtils;
        scope.ServerConfig = {
            Backend:null
        }

        scope.canChangeConfig = scope.editable || $routeParams.backupid === undefined;
        scope.isSettings = $routeParams.backupid == null && $scope.remotePathMustExist && scope.editable;

        $scope.setBuilduriFn({ builduriFn: (callback => BackupConnectionService.buildUri(scope.ServerConfig, callback)) });

        $scope.changeConfiguration = function() {
            $scope.isValid = false;
        }
        
        $scope.testConnection = async function() {
            if ($scope.Path !== '') {

                scope.Testing = true;

                const opts = {};
                EditUriBackendConfig.merge_in_advanced_options(scope.ServerConfig, opts);

                const serverConfig = new ServerConfig(
                    scope.ServerConfig.Backend.Key,
                    scope.ServerConfig.Server,
                    scope.ServerConfig.Port,
                    (scope.ServerConfig.folderPathPrefix || '') + (scope.ServerConfig.Path || ''),
                    AppUtils.encodeDictAsUrl(opts),
                    (scope.ServerConfig.SupportsSSL && scope.ServerConfig.UseSSL),
                )
                try {
                    const res = await BackupConnectionService.checkFolderExist(serverConfig);
                    scope.uri = res;
                    reparseuri();
                    $scope.isValid = true;
                }finally {
                    scope.Testing = false;

                }
            }
        };

        $scope.contains_value = AppUtils.contains_value;

        $scope.$watch('ServerConfig.Backend', function() {
            if (scope.ServerConfig.Backend == null) {
                $scope.TemplateUrl = null;
                $scope.AdvanceOptionList = null;
                return;
            }

            var opts = angular.copy(scope.ServerConfig.Backend.Options || []);
            for(var n in opts)
                opts[n].Category = scope.ServerConfig.Backend.DisplayName;

            for(var m in SystemInfo.state.ConnectionModules)
            {
                var t = angular.copy(SystemInfo.state.ConnectionModules[m].Options);
                for(var n in t)
                    t[n].Category = SystemInfo.state.ConnectionModules[m].DisplayName;
                opts.push.apply(opts, t);
            }

            $scope.AdvanceOptionList = opts;
            scope.SupportsSSL = false;
            for(var n in scope.ServerConfig.Backend.Options)
                if (scope.ServerConfig.Backend.Options[n].Name == 'use-ssl')
                    scope.SupportsSSL = true;
                    
            scope.TemplateUrl = EditUriBackendConfig.templates[scope.ServerConfig.Backend.Key];
            if (scope.TemplateUrl == null)
                scope.TemplateUrl = EditUriBackendConfig.defaulttemplate;

            if (EditUriBackendConfig.loaders[scope.ServerConfig.Backend.Key] == null)
                return;

            EditUriBackendConfig.loaders[scope.ServerConfig.Backend.Key](scope);
        });

        const reparseuri = function() {
            if (!scope.uri)
            {
                return;
            }

            scope.ServerConfig = BackupService.reparseuri(scope.uri, scope.folderPathPrefix, scope.DefaultBackend, scope.SystemInfo.GroupedBackendModules);
            validatedPath = scope.ServerConfig.Path;
        };

        $scope.SystemInfo = SystemInfo.watch($scope, function() {
            for(var n in scope.SystemInfo.GroupedBackendModules)
                if (scope.SystemInfo.GroupedBackendModules[n].Key == EditUriBackendConfig.defaultbackend)
                    scope.DefaultBackend = scope.SystemInfo.GroupedBackendModules[n];

            reparseuri();
        });
        $scope.$watch('uri', reparseuri);
    }
  };
});
