backupApp.controller('HomeController', function ($scope, $location, ServerStatus, BackupList, AppService, AppUtils, BackupService, DialogService, gettextCatalog) {
    $scope.backups = BackupList.watch($scope);

    $scope.doRun = function(id) {
        AppService.post('/backup/' + id + '/run').then(function() {
            if (ServerStatus.state.programState == 'Paused') {
                DialogService.dialog(gettextCatalog.getString('Server paused'), gettextCatalog.getString('Server is currently paused, do you want to resume now?'), [gettextCatalog.getString('No'), gettextCatalog.getString('Yes')], function(ix) {
                    if (ix == 1)
                        ServerStatus.resume();
                });

            }
        }, function() {});
    };

    $scope.doRestore = function(id) {
        $location.path('/restore/' + id);
    };

    $scope.doEdit = function(id) {
        $location.path('/edit/' + id);
    };

    $scope.doExport = function(id) {
        BackupService.ExportBackup(id);
        // $location.path('/export/' + id);
    };

    $scope.doCompact = function(id) {
        AppService.post('/backup/' + id + '/compact');
    };

    $scope.doDelete = function(id, name) {
        BackupService.DeleteBackup(id);
        // $location.path('/delete/' + id);
    };

    $scope.doLocalDb = function(id) {
        $location.path('/localdb/' + id);
    };

    $scope.doRepairLocalDb = function(id, name) {
        AppService.post('/backup/' + id + '/repair');
    };

    $scope.doVerifyRemote = function(id, name) {
        AppService.post('/backup/' + id + '/verify');
    };

    $scope.doShowLog = function(id, name) {
        $location.path('/log/' + id);
    };

    $scope.doCommandLine = function(id, name) {
        $location.path('/commandline/' + id);
    };

    $scope.doCreateBugReport = function(id, name) {
        AppService.post('/backup/' + id + '/createreport');
    };

    $scope.toggleBackup = function(index)
    {
        const backup = $scope.backups[index].Backup;
        function handleResponse(response) {
            if (response.data != true)
            {
                $scope.backups[index].Backup.Enabled = !backup.Enabled;
            }
            $scope.toggling = false;
            $scope.$digest();
        }

        $scope.toggling = true;
        if (!backup.Enabled) { // means it was true before
            AppService.put('/backup/' + backup.ID + '/disable')
                .then(response => setTimeout(() => handleResponse(response), 500));
        }
        else {
            AppService.put('/backup/' + backup.ID + '/enable')
                .then(response => setTimeout(() => handleResponse(response), 500));
        }

    }

    $scope.formatDuration = AppUtils.formatDuration;


    $scope.CurrentBackupStatus = function(item) {
        if (item.Backup.Metadata === null) return 'None';


        if (item.Backup.ID == ServerStatus.state.activeTask?.Item2 && ServerStatus.state.programState == 'Running') return 'Running';
        if (item.Backup.ID == ServerStatus.state.activeTask?.Item2 && ServerStatus.state.programState == 'Paused') return 'Paused';

        return $scope.LastBackupStatus(item);
    }

    $scope.LastBackupStatus = function(item) {
        if (item.Backup.Metadata === null) return 'None';

        const LastBackupStart = item.Backup.Metadata.LastBackupStarted ?? item.Schedule.LastRun
        
        if (item.Backup.Metadata.LastErrorDate !== undefined && item.Backup.Metadata.LastErrorDate >= LastBackupStart) return 'Failed';
        if (item.Backup.Metadata.LastBackupStarted < item.Backup.Metadata.LastBackupFinished) return 'Success'

        if (item.Backup.Metadata.LastBackupStarted === undefined) return 'None';
        
        return 'Unknown'
    }
});
