backupApp.directive('notificationArea', function() {
  return {
    restrict: 'E',
    templateUrl: 'templates/notifications/area.html?v=1.1.1.2',
    controller: function($scope, $location, $timeout, gettextCatalog, NotificationService, ServerStatus, AppService, AppUtils, DialogService) {
        $scope.Notifications = NotificationService.watch($scope);
        $scope.state = ServerStatus.watch($scope);
        $scope.hasNewNotification = false;

        $scope.NotificationPanelIsOpen = false;
        $scope.OpenNotificationPanel = function() { $scope.NotificationPanelIsOpen = true; }
        $scope.CloseNotificationPanel = function() { $scope.NotificationPanelIsOpen = false; }

        
        $scope.$on('notificationschanged', function() {
            $scope.hasNewNotification = false;
            for(const notif of $scope.Notifications)
            {
                if (!notif.HasBeenSeen)
                {
                    $scope.hasNewNotification = true;
                    if(notif.Type.toLowerCase() == 'error')
                    {
                        $scope.OpenNotificationPanel();
                        break;
                    }
                }
            }
        });



        $scope.GetItemIcon = function(type)
        {
            if (type.toLowerCase() === "error")
            {
                return "ic-x-fill";
            }
            if (type.toLowerCase() === "warning")
            {
                return "ic-alert-triangle";
            }
            if (type.toLowerCase() === "success")
            {
                return "ic-check-fill";
            }

            return "ic-info-fill"
        }
        
        
        $scope.RelativeDate = function(date)
        {
            return AppUtils.RelativeDate(date);
        }

        $scope.doDismiss = function(id) {

            const notifItem = document.getElementById(`notification-item-${id}`);
            notifItem.style.maxHeight = notifItem.clientHeight +'px';
            setTimeout(() => { notifItem.style.maxHeight = '0'; }, 50);
            notifItem.classList.add('deleting')
            setTimeout(() => {
                AppService.delete('/notification/' + id).then(
                    function() { }, // Don't care, the message will be removed
                    function(resp) {
                        // Most likely there was a sync problem, so attempt to reload
                        NotificationService.refresh_notifications();
                    }
                );
            }, 1200)
        };

        $scope.doDismissAll = function() {
            angular.forEach($scope.Notifications, function(value, key){
                id = value['ID'];
                AppService.delete('/notification/' + id).then(
                    function() { $scope.CloseNotificationPanel(); }, // Don't care, the message will be removed
                    function(resp) {
                        // Most likely there was a sync problem, so attempt to reload
                        NotificationService.refresh_notifications();
                    }
                );
            });
        };

        $scope.flagAsSeen = function(id) {
            AppService.put('/notification/' + id).then(
                function() { }, // Don't care, the message will be removed
                function(resp) {
                    // Most likely there was a sync problem, so attempt to reload
                    NotificationService.refresh_notifications();
                }
            );
        };

        $scope.doShowLog = function(backupid) {
            AppService.get('/backup/' + backupid + '/isactive').then(
                function() {
                    $location.path('/log/' + backupid);
                },

                function(resp) {

                    if (resp.status == 404) {
                        if ((parseInt(backupid) + '') != backupid)
                            DialogService.dialog(gettextCatalog.getString('Error'), gettextCatalog.getString('The backup was temporary and does not exist anymore, so the log data is lost'));
                        else
                            DialogService.dialog(gettextCatalog.getString('Error'), gettextCatalog.getString('The backup is missing, has it been deleted?'));
                    } else {
                        AppUtils.connectionError(gettextCatalog.getString('Failed to find backup: '), resp);
                    }

                }
            );
        };

        $scope.doRepair = function(backupid) {
            AppService.post('/backup/' + backupid + '/repair');
            $location.path('/');
        };

        $scope.doInstallUpdate = function(id) {
            AppService.post('/updates/install');
        };

        $scope.doActivateUpdate = function(id) {
            AppService.post('/updates/activate').then(function() { $scope.doDismiss(id); }, AppUtils.connectionError('Activate failed: '));
        };

        $scope.doShowUpdate = function(id) {
            $location.path('/updatechangelog'); 
        };

        $scope.doDownloadBugreport = function(item) {
            var id = item.Action.substr('bug-report:created:'.length);
            item.DownloadLink = $scope.DownloadLink = AppService.get_bugreport_url(id);
        };
    }
  }
});
