backupApp.directive('paginationFooter', function () {
    return {
        restrict: 'E',
        scope: {
            pageSize: '=?',
            totalItems: '=?',
            onChange: '&'
        },
        templateUrl: 'templates/components/table/pagination-footer.html?v=1.1.1.2',
        controller: function ($scope) {
            const scope = $scope;
            scope.ItemsPerPageValues = [10, 15, 50, 100];
            scope.PageSize = scope.pageSize || 10;
            scope.CurrentPage = 1;
            scope.From = 1;
            
            scope.$watch('PageSize', function(newPageSize, oldPageSize) {
                if (newPageSize !== oldPageSize) {
                    var newFilterParams = {
                        pageSize: newPageSize
                    }
                    scope.onChange({newFilterParams});
                    if (scope.TotalItems) {
                        scope.TotalPages = Math.ceil(scope.totalItems / scope.PageSize);
                        scope.CurrentPage = 1;
                    }
                }
            });
            
            scope.$watch('totalItems', function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    scope.TotalItems = !!scope.totalItems ? scope.totalItems : 0;
                    scope.TotalPages = Math.ceil(scope.totalItems / scope.PageSize);
                    
                }
            })

            scope.NextPage = function() {
                scope.CurrentPage++;
                scope.ApplyFilter();
            }
            
            scope.ToLastPage = function () {
                scope.CurrentPage = scope.TotalPages;
                scope.ApplyFilter();
            }

            scope.PreviousPage = function() {
                scope.CurrentPage--;
                scope.ApplyFilter();
            }
            
            scope.ToFirstPage = function () {
                scope.CurrentPage = 1;
                scope.ApplyFilter();
            }
            
            scope.ApplyFilter = function () {
                var newFilterParams = {
                    pageSize: scope.PageSize,
                    offset: scope.TotalItems - ((scope.CurrentPage - 1) * scope.PageSize - 1)
                }
                scope.onChange({newFilterParams});
            }

            scope.$watch('CurrentPage', function(newPage, oldPage) {
                if (newPage !== oldPage) {
                    scope.UpdatePagination();
                }
            });

            scope.UpdatePagination = function () {
                const startIndex = (scope.CurrentPage - 1) * scope.PageSize + 1;
                let endIndex = Math.min(startIndex + scope.PageSize - 1, scope.TotalItems);
                if (scope.TotalItems === 0) {
                    endIndex = 0;
                }

                scope.From = startIndex;
                scope.To = endIndex;
            }

            scope.$watchGroup(['CurrentPage', 'PageSize', 'TotalItems'], function() {
                scope.UpdatePagination();
            });
        }
    }
});