backupApp.directive('remoteLogsTable', function () {
    return {
        restrict: 'E',
        scope: {
            backupId: '=',
            page: '='
        },
        templateUrl: 'templates/backups/logs/remote-logs-table.html?v=1.1.1.2',
        controller: function ($scope, LogService, BackupList, AppUtils) {
            const scope = $scope;
            scope.toDateTimeFormat = AppUtils.toDateTimeFormat;

            $scope.remoteLogsFilterParams = {
                pageSize: 10,
                offsett: null,
            }
            
            scope.$watch('page', function(newValue, oldValue) {
                if (newValue == 'remote' && scope.RemoteLogs == null)
                    $scope.GetAll(true);
            });

            $scope.logDetails = null;
            $scope.OpenLogDetailsModal = function(logDetails) {
                $scope.logDetails = logDetails;
            }

            $scope.CloseLogDetailsModal = function () {
                $scope.logDetails = null;
            }

            $scope.GetAll = function(isInit) {
                LogService.GetAll('/backup/' + scope.backupId + '/remotelog', $scope.remoteLogsFilterParams)
                    .then(function(result) {
                        if (!result)
                            return;
                        
                        $scope.RemoteLogs = result.data;
                        $scope.Backup = BackupList.lookup[$scope.BackupID];
                        if (result.data && result.data.length && isInit) {
                            $scope.totalItems = result.data[0].ID;
                        }
                        $scope.$digest();
                    });
            };

            scope.handleFilterChange = function(newFilterParams) {
                $scope.remoteLogsFilterParams = newFilterParams;
                $scope.GetAll(false);
            };
        }
    }
});