backupApp.directive('logDetailsModal', function () {
    return {
        restrict: 'E',
        scope: {
            modalType: '=',
            backupId: '=',
            log: '=',
            onClose: '&'
        },
        templateUrl: 'templates/backups/logs/log-details-modal.html?v=1.1.1.2',
        controller: function ($scope, AppUtils, gettextCatalog) {
            const scope = $scope
            scope.sectionsData = [];
            scope.summaryData = [];
            scope.headerDate;
            scope.headerTitle;
            
            scope.toDateTimeFormat = AppUtils.toDateTimeFormat;
            scope.formatDuration = AppUtils.formatDuration;
            scope.formatSizeString = AppUtils.formatSizeString;
            
            scope.CloseModal = function () {
                scope.log = null;
                scope.onClose();
            }
            
            scope.$watch('log', function(newValue, oldValue) {
                if (newValue) {
                    scope.modalTitle = gettextCatalog.getString('Operation details');
                    if (scope.modalType === 'generalDetails') {
                        scope.initGeneralLogsSectionsData(newValue.Result);
                        scope.initGeneralLogsSummaryData(newValue.Result);
                        scope.headerDate = AppUtils.toDateTimeFormat(newValue.Result.EndTime)
                    } else if (scope.modalType === 'remoteDetails') {
                        scope.initRemoteLogsSectionsData(newValue);
                        scope.initRemoteLogsSummaryData(newValue);
                        scope.headerDate = AppUtils.toDateTimeFormat(newValue.Timestamp)
                    } else {
                        scope.initCompleteLogSummaryData(newValue);
                        scope.headerDate = AppUtils.toDateTimeFormat(newValue.Result.EndTime);
                        scope.modalTitle = gettextCatalog.getString('Operation journal');
                    }
                }
            });
            
            scope.initRemoteLogsSectionsData = function (remoteLog) {
                scope.sectionsData = [
                    {
                        groupTitle: gettextCatalog.getString('Service actions'),
                        data: [
                            {
                                title: gettextCatalog.getString('Operation'),
                                value: remoteLog.Operation
                            },
                            {
                                title: gettextCatalog.getString('Path'),
                                value: remoteLog.Path
                            }
                        ]
                    }
                ]
            };

            scope.initGeneralLogsSectionsData = function (logResult) {
                scope.sectionsData = [
                    {
                        groupTitle: gettextCatalog.getString('Schedules'),
                        data: [
                            {
                                title: gettextCatalog.getString('Startup'),
                                value: AppUtils.toDateTimeFormat(logResult.BeginTime),
                            },
                            {
                                title: gettextCatalog.getString('End'),
                                value: AppUtils.toDateTimeFormat(logResult.EndTime),
                            },
                            {
                                title: gettextCatalog.getString('Duration'),
                                value: AppUtils.formatDuration(logResult.Duration),
                            },
                        ]
                    },
                    {
                        groupTitle: gettextCatalog.getString('Source Files'),
                        data: [
                            {
                                title: gettextCatalog.getString('Examined'),
                                value: (logResult.ExaminedFiles || '0') + '(' + AppUtils.formatSizeString(logResult.SizeOfExaminedFiles) +')',
                            },
                            {
                                title: gettextCatalog.getString('Opened'),
                                value: (logResult.OpenedFiles || '0') + '(' + AppUtils.formatSizeString(logResult.SizeOfOpenedFiles) +')',
                            },
                            {
                                title: gettextCatalog.getString('Added'),
                                value: (logResult.AddedFiles || '0') + '(' + AppUtils.formatSizeString(logResult.SizeOfAddedFiles) +')',
                            },
                            {
                                title: gettextCatalog.getString('Modified'),
                                value: (logResult.ModifiedFiles || '0') + '(' + AppUtils.formatSizeString(logResult.SizeOfModifiedFiles) +')',
                            },
                            {
                                title: gettextCatalog.getString('Deleted'),
                                value: logResult.DeletedFiles || '0',
                            },
                        ]
                    }
                ]
            }

            scope.initCompleteLogSummaryData = function (log) {
                scope.summaryData = [
                    {
                        title: gettextCatalog.getString('Complete log'),
                        isOpened: true,
                        data: log.Result
                    }
                ]
            }

            scope.initRemoteLogsSummaryData = function(remoteLog) {
                scope.summaryData = [
                    {
                        title: gettextCatalog.getString('Data'),
                        isOpened: true,
                        data: JSON.parse(remoteLog.Data)
                    },
                ]
            }

            scope.initGeneralLogsSummaryData = function(logResult) {
                scope.summaryData = [
                    {
                        title: gettextCatalog.getString('Testing stage'),
                        isOpened: false,
                        status: scope.logStatus(logResult.TestResults),
                        data: logResult.TestResults
                    },
                    {
                        title: gettextCatalog.getString('Alerts'),
                        isOpened: false,
                        status: logResult.Warnings.length ? 'unknown' : 'success',
                        data: logResult.Warnings
                    },
                    {
                        title: gettextCatalog.getString('Errors'),
                        isOpened: false,
                        status: logResult.Errors.length ? 'failed' : 'success',
                        data: logResult.Errors
                    }
                ]
            }

            scope.logStatus = function(testResults) {
                if (!testResults || !testResults.ParsedResult) {
                    return 'failed';
                }
                if (testResults.ParsedResult == 'Success') {
                    return 'success';
                } else if (testResults.ParsedResult == 'Warning') {
                    return 'unknown';
                } else if (testResults.ParsedResult == 'Error') {
                    return 'failed';
                } else {
                    return 'none';
                }
            }
        }
    }
})