backupApp.directive('generalLogsTable', function () {
    return {
        restrict: 'E',
        scope: {
            backupId: '=',
            page: '='
        },
        templateUrl: 'templates/backups/logs/general-logs-table.html?v=1.1.1.2',
        controller: function ($scope, LogService, BackupList, AppUtils) {
            const scope = $scope;
            
            scope.filterParams = {
                pageSize: 10,
                offsett: null,
            }

            $scope.logDetails = null;
            $scope.modalType = null;
            $scope.OpenLogDetailsModal = function(logDetails, modalType) {
                $scope.logDetails = logDetails;
                $scope.modalType = modalType;
            }
            
            $scope.CloseLogDetailsModal = function () {
                $scope.logDetails = null;
                $scope.modalType = null;
            }
            
            scope.formatDuration = AppUtils.formatDuration;
            scope.toDateTimeFormat = AppUtils.toDateTimeFormat;

            scope.GetAll = function(isInit) {
                LogService.GetAll('/backup/' + scope.backupId + '/log', scope.filterParams)
                    .then(function(result) {
                        if (!result)
                            return;

                        var data = result.data;
                        $scope.Backup = BackupList.lookup[scope.backupId];
                        for (var i in data) {
                            try {
                                data[i].Result = JSON.parse(data[i].Message);
                            }
                            catch (err) {
                                // catch block meant to be empty (avoiding eslint warning)
                                // it is empty because if a result fails to be parsed, it was
                                // probably stored in the old format and thus should be displayed
                                // with a single gray code box.
                            }
                        }
                        $scope.PaginatedLogs = data;
                        if (data && data.length && isInit) {
                            $scope.totalItems = data[0].ID;
                        }
                        $scope.$digest();
                    });
            };
            
            scope.handleFilterChange = function(newFilterParams) {
                scope.filterParams = newFilterParams;
                $scope.GetAll(false);
            };
            
            scope.OperationStatus = function(item) {
                if (!item.Result) {
                    return 'none';
                }
                var parsedResult = item.Result.ParsedResult;
                if (parsedResult == 'Success') {
                    return 'success';
                } else if (parsedResult == 'Warning') {
                    return 'unknown';
                } else if (parsedResult == 'Error') {
                    return 'failed';
                } else {
                    return 'none';
                }
            }
            scope.GetAll(true);
        }
    }
});