backupApp.controller('ImportController', function($rootScope, $scope, $timeout, $location, gettextCatalog, AppService, DialogService, ServerStatus) {
    $scope.Connecting = false;
    $scope.Completed = false;
    $scope.ImportURL = AppService.get_import_url();
    $scope.UploadDownloads = null;
    $scope.step = 1;
    $scope.importComplete = false

    $scope.cleanFile = function() {
        document.getElementById('file').value = null;
        $scope.UploadDownloads = null;
    }

    $scope.doSubmit = async function() {
        $scope.Connecting = true;
        $scope.importBackup = await readFile();
        
        $scope.Connecting = false;
        $scope.step = 2;
        $scope.$digest();

    };

    $scope.onCompleteTask = function() {
        $scope.importComplete = true;
    }

    function readFile()
    {
        return new Promise((resolve, reject) => {
            const reader = new FileReader();
            const [file] = document.getElementById('file').files;

            reader.addEventListener(
                "load",
                () => {
                    const config = JSON.parse(reader.result);
                    resolve(config)
                },
                false,
            );

            if (file) {
                reader.readAsText(file)
            }
        });
    }

    
    $scope.goToMyBackups = function() {
        $location.path('/')
    }
});
