backupApp.directive('settingSftpServerConfig', function (gettextCatalog) {
    return {
        restrict: 'E',
        scope: {
            uri: '=uri',
            sshKey: '=sshKey',
            folderPathPrefix: '=',
            isValid: '=',
            canChangeConfig: '='
        },
        templateUrl: 'templates/settings/sftp-server-config.html?v=1.1.1.1',
        controller: function ($scope, $routeParams, AppService, AppUtils, BackupConnectionService, BackupService, SystemInfo, EditUriBackendConfig, DialogService) {
            const scope = $scope;
            
            const handleSshKey = function () {
                if (!scope.sshKey) {
                    return;
                }
                scope.UseSshKey = true;
                scope.ssh = scope.sshKey.split('\n')
            }
           
            const reparseuri = function () {
                if (!scope.uri)
                {
                    return;
                }

                if (scope.uri.includes('ssh-key'))
                {
                    scope.uri = EditUriBackendConfig.remove_param_from_uri(scope.uri, 'ssh-key');
                }

                scope.ServerConfig = BackupService.reparseuri(scope.uri, scope.folderPathPrefix, scope.DefaultBackend, scope.SystemInfo.GroupedBackendModules);
                scope.ServerConfig.Path = '';
            };
            scope.$watch('sshKey', handleSshKey);
            scope.$watch('uri', reparseuri);
            scope.SystemInfo = SystemInfo.watch($scope, function () {
                for (var n in scope.SystemInfo.GroupedBackendModules)
                    if (scope.SystemInfo.GroupedBackendModules[n].Key == EditUriBackendConfig.defaultbackend)
                        scope.DefaultBackend = scope.SystemInfo.GroupedBackendModules[n];

                reparseuri();
            });

            scope.changeConfiguration = () => scope.isValid = false;
            scope.testConnection = async function () {
                scope.Testing = true;
                const hasSshKey = scope.UseSshKey && scope.ssh;
                var mergedSshKey = null;
                if (hasSshKey) {
                    mergedSshKey = scope.ssh.join("\n");
                }
                const opts = hasSshKey
                    ? { 'ssh-key': mergedSshKey }
                    : {}
                EditUriBackendConfig.merge_in_advanced_options(scope.ServerConfig, opts);
                if (!scope.ServerConfig.folderPathPrefix.endsWith('/'))
                {
                    scope.ServerConfig.folderPathPrefix += '/';
                }
               
                const serverConfig = new ServerConfig(
                    'ssh',
                    scope.ServerConfig.Server,
                    scope.ServerConfig.Port,
                    scope.ServerConfig.folderPathPrefix,
                    AppUtils.encodeDictAsUrl(opts),
                    false,
                )
                try {
                    const res = await BackupConnectionService.performConnectionTest(serverConfig, $routeParams.backupid);
                    scope.folderPathPrefix = scope.ServerConfig.folderPathPrefix;
                    scope.uri = res;
                    reparseuri();
                    scope.sshKey = hasSshKey ? mergedSshKey : null;
                    $scope.isValid = true;
                }finally {
                    scope.Testing = false;

                }
            };
        }
    }
});