backupApp.directive('checkbox', function (gettextCatalog) {
    return {
        restrict: 'E',
        scope: {
            id: '=id',
            type: '=',
            model: '=',
            label: '=',
            value: '=',
            translateParameters: '=',
            onChange: '&'
        },
        templateUrl: 'templates/components/inputs/checkbox.html?v=1.1.1.1',
        controller: function ($scope, gettextCatalog) {

            $scope.text = gettextCatalog.getString($scope.label, $scope.translateParameters);
            if ($scope.onChange)
            {
                $scope.$watch('model', () => $scope.onChange({ value: $scope.value }));
            }
        }
    }
});